package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "documentreviewstatus", schema = "hib")
public class DocumentReviewStatus {

	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY) // because of course SQL Server doesn't support sequences.
	private int id;
	
	@JoinColumn(name = "documentid")
	@ManyToOne(fetch = FetchType.LAZY)
	private Document document;
	
	@JoinColumn(name = "groupid")
	@ManyToOne(fetch = FetchType.LAZY)
	private Group group;
	
	@JoinColumn(name = "reviewerid")
	@ManyToOne(fetch = FetchType.LAZY)
	private Person reviewer;
	
	@Column(name="status")
	private String status;
	
	DocumentReviewStatus(){}
	
	public static DocumentReviewStatus findById(final int documentId, final int reviewerId, final int groupId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getDocumentReviewStatusDAO().findById(documentId, reviewerId, groupId);
	}
	
	public static DocumentReviewStatus findByGroupId(final int documentId, final int groupId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getDocumentReviewStatusDAO().findByGroupId(documentId, groupId);
	}
	
	public static int countGroupId(final int documentId, final int groupId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getDocumentReviewStatusDAO().countGroupId(documentId, groupId);
	}

	public static List<DocumentReviewStatus> listByReviewerId(final int reviewerId) {
		return DartObjectFactory.getInstance().getDocumentReviewStatusDAO().listByReviewerId( reviewerId);
	}

	public static DocumentReviewStatus create(final Document document, final Person reviewer, final Group group, final String status) throws ValidationException {
		ValidationHelper.required("Document", document);
		ValidationHelper.required("Reviewer", reviewer);
		ValidationHelper.required("Group", group);
		
		DocumentReviewStatus result = new DocumentReviewStatus();
		result.document = document;
		result.reviewer = reviewer;
		result.group = group;
		result.status = status;
		
		DartObjectFactory.getInstance().getDocumentReviewStatusDAO().save(result);
		
		return result;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Document getDocument() {
		return document;
	}

	public Person getReviewer() {
		return reviewer;
	}
	
	public Group getGroup() {
		return group;
	}
	
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	
	@Override 
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof DocumentReviewStatus) == false) {	//may want to use isAssignableFrom()
			return false;
		}
		
		return this.getId() == ((DocumentReviewStatus)obj).getId();	//compare the id column
	}
	
}
